- [Reddit post on Analytics PM courses](https://www.reddit.com/r/ProductManagement/comments/vemlah/best_product_analytics_courses/)

### Process steps in Data Science
6 stages as per [Cross-industry standard process for data mining - Wikipedia](https://en.wikipedia.org/wiki/Cross-industry_standard_process_for_data_mining)
- Business Understanding
- Data Understanding
- Data Preparation
- Modeling
- Evaluation
- Deployment
![[Process diagram of CRISM-DM.png|600]]

### Key algorithms
Key tasks addressed by data mining and data science algorithms
1. Classification - estimating if a certain event will happen or not given certain input
	1. E.g. - Estimating if customers will churn or not. Estimating if customers will respond to marketing offer or not
2. Regression - Predicting how much value of event outcome given certain input
	1. E.g. - Estimating how much service usage a given customer will have
3. Similarity matching - finding people who are similar to you based on data known about them
	1. E.g. - Product recommendations based on what people like you have purchased in the past
4. Clustering - group individuals in a population together by their similarity, but not driven by any specific purpose
	1. E.g. - Structuring customer care team based on clusters of customers they serve
5. Co-occurrence grouping - finding what products are purchased together, market-basket analysis
	1. E.g. - Amazon recommendation of people who bought X also bought Y
6. Profiling - Used to characterize typical behavior or attributes or a group of users. Used for anomaly detection too.
	1. E.g. Cell phone users profiled based on their location, usage, services, demographics
7. Link prediction - Used in networked user data. 
	1. E.g. Facebook user A and user B have 10+ common friends, so recommend that A and B should be friends
8. Data reduction - Take larger dataset, keep information relevant but reduce number of attributes so that smaller dataset is easier to deal with.
	1. Involves loss of information, and hence, minimizing loss function is important.
	2. Optimum trade-off is necessary.
9. Causal modeling - To understand what events will influence/cause other events.
	1. E.g. - Identify if marketing offer caused users to purchase products.


